/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.particle.DMC;

import com.dfdyz.epicacg.client.render.EpicACGRenderType;
import com.dfdyz.epicacg.utils.RenderUtils;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class AirWaveParticle
extends NoRenderParticle {
    int count;
    Queue<Wave> waves = Queues.newConcurrentLinkedQueue();

    public AirWaveParticle(ClientLevel level, double x, double y, double z, int waveCount, int lifetime) {
        super(level, x, y, z);
        this.f_107225_ = lifetime;
        this.count = waveCount;
        this.waves.add(new Wave(9.0f, 0.2f, 30));
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_ && this.waves.size() == 0) {
            this.m_107274_();
        } else if (this.f_107224_ < this.f_107225_ && this.f_107224_ % 3 == 0) {
            this.waves.add(new Wave(9.0f, 0.2f, 40));
        }
        this.waves.forEach(wave -> {
            wave.tick();
            wave.pushParticle(this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107223_);
        });
        this.waves.removeIf(Wave::isEnd);
    }

    public boolean shouldCull() {
        return false;
    }

    static class Wave {
        float r = 0.2f;
        float rO = 0.2f;
        float targetR;
        float smooth;
        int lifetime;
        int age = 0;

        public Wave(float targetR, float smooth, int lft) {
            this.targetR = targetR;
            this.smooth = smooth;
            this.lifetime = lft;
        }

        public void tick() {
            this.rO = this.r;
            this.r = Mth.m_14179_((float)this.smooth, (float)this.r, (float)this.targetR);
            ++this.age;
        }

        public boolean isEnd() {
            return this.age >= this.lifetime;
        }

        public void pushParticle(ClientLevel level, double x, double y, double z, RandomSource random) {
            int inter = Math.max(1, (int)((this.r - this.rO) / 0.2f));
            float perR = (this.r - this.rO) / (float)inter;
            float perYAdder = 0.5f / (float)inter;
            for (int j = 0; j < inter; ++j) {
                int cnt = Math.max(6, (int)(Math.PI * (double)(this.rO + perR * (float)j) * 2.0 / 0.2));
                double perAng = Math.PI * 2 / (double)cnt;
                for (int i = 0; i < cnt; ++i) {
                    double x_ = Math.cos(perAng * (double)i) * (double)(this.rO + perR * (float)j);
                    double z_ = Math.sin(perAng * (double)i) * (double)(this.rO + perR * (float)j);
                    RenderUtils.AddParticle(level, new AirParticle(level, x_ + x + Mth.m_216263_((RandomSource)random, (double)-0.2, (double)0.2), y + Mth.m_216263_((RandomSource)random, (double)-0.2, (double)0.2) + (double)(perYAdder * (float)j), z_ + z + Mth.m_216263_((RandomSource)random, (double)-0.2, (double)0.2), Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05), 0.25, Mth.m_216263_((RandomSource)random, (double)-0.05, (double)0.05), (int)(6.0f / (float)inter * (float)(j + 1))));
                }
            }
        }
    }

    public static class AirParticle
    extends Particle {
        float alphaO;
        static EpicACGRenderType.EpicACGQuadParticleRenderType renderType = EpicACGRenderType.getRenderTypeByTexture(RenderUtils.GetTexture("particle/photo2"));

        public AirParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, int lifetime) {
            super(level, x, y, z, xd, yd, zd);
            this.f_107215_ = xd;
            this.f_107216_ = yd;
            this.f_107217_ = zd;
            this.alphaO = this.f_107230_;
            this.f_107219_ = false;
            this.f_107225_ = lifetime;
        }

        public void m_5989_() {
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            this.alphaO = this.f_107230_;
            if (this.f_107224_++ >= this.f_107225_) {
                this.m_107274_();
            } else {
                this.f_107212_ += this.f_107215_;
                this.f_107213_ += this.f_107216_;
                this.f_107214_ += this.f_107217_;
            }
            this.f_107230_ = Math.min(0.5f, 0.5f * (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_);
            this.f_107230_ = Math.max(this.f_107230_, 0.0f);
            this.m_107264_(this.f_107212_, this.f_107213_, this.f_107214_);
        }

        float getAlpha(float pt) {
            return Mth.m_14179_((float)pt, (float)this.alphaO, (float)this.f_107230_);
        }

        public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float pt) {
            float alp = this.getAlpha(pt);
            float t_ = ((float)(this.f_107224_ % 10) + pt) / 9.0f;
            t_ = t_ <= 0.5f ? 4.0f * t_ - 1.0f : -4.0f * t_ + 3.0f;
            float sz = (0.5f + 0.1f * t_) * alp * 1.8f;
            RenderUtils.RenderQuadFaceOnCamera2(vertexConsumer, camera, (float)Mth.m_14139_((double)pt, (double)this.f_107209_, (double)this.f_107212_), (float)Mth.m_14139_((double)pt, (double)this.f_107210_, (double)this.f_107213_), (float)Mth.m_14139_((double)pt, (double)this.f_107211_, (double)this.f_107214_), this.f_107227_, this.f_107228_, this.f_107229_, alp, sz);
        }

        public ParticleRenderType m_7556_() {
            return renderType;
        }

        public boolean shouldCull() {
            return false;
        }
    }
}

